<?php

namespace App\Http\Requests;

class UpdateCountryRequest extends StoreCountryRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = parent::rules();
        $rules['code'] = 'required|string|max:6|unique:countries,code,'.$this->country->id;
        $rules['flag'] = 'nullable|image|mimes:jpg,jpeg,png|max:1024';

        return $rules;
    }
}
